function criar_campos(id,tipo) {
	
var input = document.createElement("input");
input.type = tipo;
input.id = id;
input.value = "";
return input;
}

window.onload = function(){

  // Cria os campos ocultos para uso nas funes
  document.body.appendChild(criar_campos("idVpm","hidden"));
  document.body.appendChild(criar_campos("idVt","hidden"));
  document.body.appendChild(criar_campos("idDesconto","hidden"));
  document.body.appendChild(criar_campos("idDesconto_Acrescimo","hidden"));
  document.body.appendChild(criar_campos("idMeses","hidden"));
  
}

function set_total() {

  var idVpm = parseFloat(document.getElementById("idVpm").value);
  var idVt = parseFloat(document.getElementById("idVt").value);
  var idDesconto = parseFloat(document.getElementById("idDesconto").value);
  var idDesconto_Acrescimo = parseFloat(document.getElementById("idDesconto_Acrescimo").value);
  var idMeses = parseFloat(document.getElementById("idMeses").value);

  var total_tudo = 0;
	 
  total_tudo = parseFloat(idVt);
  
  if(idMeses > 1 && idDesconto > 0) {
	
	vt = (total_tudo * idMeses);
	valor_porcento = ((idDesconto/100)*vt);
	total_tudo = (vt - valor_porcento);
	
  } else if(idMeses >= 1 && idDesconto == 0) {
	  
	total_tudo = parseFloat(total_tudo * idMeses);
  
  }
  
  if(idDesconto_Acrescimo != "" && !isNaN(idDesconto_Acrescimo)){
	total_tudo = parseFloat(total_tudo + idDesconto_Acrescimo);
  }
  
	document.getElementById("valor_total").value = total_tudo;
	
	// Debug
	//alert("Valor total: "+total_tudo);

	number_format("div_valor_total",total_tudo);

}

function pesquisar_plano( codigo ) {
  
  if(codigo != "") {
  
  document.getElementById( 'div_valor_total' ).innerHTML = "<img src='img/spinner.gif' />";
	  
  var http = new Ajax();
  http.open("GET", "inc/funcoes.assinatura.php?acao=pesquisar_plano&codigo=" + codigo, true);
  http.onreadystatechange = function() {
  
 	if (http.readyState == 4) {
  	resultado = http.responseText;

	partes = resultado.split("&");
	
	var valor_total_setup_plano = ((parseFloat(partes['0']))+(parseFloat(partes['1'])));
	var valor_total_plano = partes['0'];
	
	// Grava os campos principais com os dados do plano
	document.getElementById("idVpm").value = valor_total_setup_plano;
	document.getElementById("idVt").value = valor_total_plano;
	
	// Executar funo da periodicidade mnima
	periodicidade_minima((partes['2']));
	
	set_total();
	
	}
   }
 }
 http.send(null);
 delete http;
}

function pesquisar_periodicidade(p) {
	
  document.getElementById( 'div_valor_total' ).innerHTML = "<img src='img/spinner.gif' />";
	
	switch(p){
		case "mensal":
			var meses = 1;
			break;
		case "bimestral":
			var meses = 2;
			break;
		case "trimestral":
			var meses = 3;
			break;
		case "semestral":
			var meses = 6;
			break;
		case "anual":
			var meses = 12;
			break;
		case "bianual":
			var meses = 24;
			break;
	}
	
  var http = new Ajax();
  http.open("GET", "inc/funcoes.assinatura.php?acao=pesquisar_periodicidade&p=" + p, true);
  http.onreadystatechange = function() {
  
 	if (http.readyState == 4) {
  	desconto = http.responseText;
	
	document.getElementById("idDesconto").value = desconto;
	document.getElementById("idMeses").value = meses;

	set_total();
	
   }
 }
 http.send(null); 
 delete http;
}

function periodicidade_minima( valor ){
	
	var arrayRadio = document.cadastro_dominio.periodicidade;
	
	var arrayDesabilitado = [];
	
	switch(valor){
		case "mensal":
			arrayDesabilitado = [];
			break;
		case "bimestral":
			arrayDesabilitado = [0];
			break;
	    case "trimestral":
			arrayDesabilitado = [0,1];
			break;
		case "semestral":
			arrayDesabilitado = [0,1,2];
			break;
		case "anual":
			arrayDesabilitado = [0,1,2,3];
			break;
		case "bianual":
			arrayDesabilitado = [0,1,2,3,4];
			break;
	}
	
	var increment = 0;
	
	if(arrayRadio[0].value == "")
		increment = 1;
		
	for(var cont = increment; cont < arrayRadio.length; cont++){
		arrayRadio[cont].disabled = false;
	}
	
	for(var cont = 0; cont < arrayDesabilitado.length; cont++){	
		arrayRadio[cont+increment].disabled = true;
	}


	for(var cont = increment; cont < arrayRadio.length; cont++){
		arrayRadio[cont].checked = false;
	}

}

function number_format( div,valor ) {
  
  var http = new Ajax();
  http.open("GET", "inc/funcoes.assinatura.php?acao=number_format&valor=" + valor, true);
  http.onreadystatechange = function() {
  
 	 if (http.readyState == 4) {
  	resultado = http.responseText;
	
 	 if (resultado) {
	 document.getElementById(div).innerHTML = resultado;
  	 }
   }
 }
 http.send(null); 
 delete http;
}

function desconto_acrescimo( valor ) {
	
  if(valor != "") {
	  
  document.getElementById( 'div_valor_total' ).innerHTML = "<img src='img/spinner.gif' />";
  
  valor = valor.replace(".","");
  valor = valor.replace(",",".");
  
  document.getElementById("idDesconto_Acrescimo").value = parseFloat(valor);
  
  set_total();
  } else {
	  
  document.getElementById( 'div_valor_total' ).innerHTML = "<img src='img/spinner.gif' />";
  document.getElementById("idDesconto_Acrescimo").value = 0;
  set_total();
  }
}
function Ajax() {
var req;

try {
 req = new ActiveXObject("Microsoft.XMLHTTP");
} catch(e) {
 try {
	req = new ActiveXObject("Msxml2.XMLHTTP");
 } catch(ex) {
	try {
	 req = new XMLHttpRequest();
	} catch(exc) {
	 alert("Esse browser no tem recursos para uso do Ajax");
	 req = null;
	}
 }
}

return req;
}